/*==============================================================================}
{ This demo shows how checkpoints can generate events when they become visible }
{------------------------------------------------------------------------------}
{ Properties set:                                                              }
{  RichView1->CPEventKind = cpeAsSectionStart                                  }
{  RichView2->CPEventKind = cpeWhenVisible                                     }
{  rvoShowCheckpoints included in Options of both RichViews                    }
{------------------------------------------------------------------------------}
{ Key properties, events and methods:                                          }
{ - CPEventKind                                                                }
{ - OnCheckpointVisible                                                        }
{ - AddNamedCheckpointEx                                                       }
{=============================================================================*/
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  int i,j;
  // 1. Filling in left RichView
  for (i=1; i<4; i++)
  {
    RichView1->AddNamedCheckpointEx(AnsiString("Chapter ")+IntToStr(i),True);
    RichView1->AddFmt("Chapter %d", ARRAYOFCONST((i)), 1,1);
    for (j=0; j<30; j++)
      RichView1->AddNLATag("Bla - bla - bla - bla - bla - bla.",0,0,0);
  }
  RichView1->Format();
  // 2. Filling in right RichView
  for (i=1; i<4; i++)
  {
    RichView2->AddNamedCheckpointEx(AnsiString("Figure ")+IntToStr(i),True);
    TIcon* ico = new TIcon;
    ico->Assign(Image1->Picture->Graphic);
    RichView2->AddPictureEx("", ico, 1, rvvaBaseline);
    RichView2->AddFmt("Figure %d", ARRAYOFCONST((i)), 3,1);
    for (j=0; j<30; j++)
      RichView2->AddNLATag("Bla - bla - bla - bla - bla - bla.",0,0,0);
  }
  RichView2->Format();
  /*
    Comments:

    1.
    In this demo we use AddNamedCheckpointEx method.
    It has second parameter - RaiseEvent: Boolean.
    If set to True, RichView will generate event when this checkpoint
    becomes visible

    2.
    Checkpoints with RaiseEvent=True can be displayed with different color
    than other checkpoints.
    Color of "normal" checkpoints: RVStyle->CheckpointColor;
    Color of "RaiseEvent" checkpoints: RVStyle->CheckpointEvColor
  */
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichView1CheckpointVisible(TCustomRichView *Sender,
    TCheckpointData CheckpointData)
{
  AnsiString Name;
  int        Tag;
  bool       RE;
  if (CheckpointData)
  {
    RichView1->GetCheckpointInfo(CheckpointData, Tag, Name, RE);
    lblChapter->Caption = Name;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichView2CheckpointVisible(TCustomRichView *Sender,
    TCheckpointData CheckpointData)
{
  AnsiString Name;
  int        Tag;
  bool       RE;
  if (CheckpointData)
  {
    RichView2->GetCheckpointInfo(CheckpointData, Tag, Name, RE);
    lblFigure->Caption = Name;
  }
  else
    lblFigure->Caption = "(none)";
}
//---------------------------------------------------------------------------